/*
 * coast.c
 *
 *  Created on: Jun 15, 2025
 *      Author: hasin
 */
#include <stdint.h>

#define PORTA_MODER   (*((volatile uint32_t *)0x48000000))
#define PORTA_OTYPE   (*((volatile uint32_t *)0x48000004))
#define PORTA_OSPEEDR (*((volatile uint32_t *)0x48000008))
#define PORTA_PUPDR   (*((volatile uint32_t *)0x4800000C))
#define PORTA_IDR     (*((volatile uint32_t *)0x48000010))
#define PORTA_ODR     (*((volatile uint32_t *)0x48000014))

#define RCC_AHBENR    (*((volatile uint32_t *)0x40021014))

void coast_gpio_init(){

	/* in HAL */
//  GPIO_InitTypeDef GPIO_InitStruct = {0};
//
//  /* GPIOA Port Clock Enable */
//  __HAL_RCC_GPIOA_CLK_ENABLE();
//
//  /*Configure GPIO pin Output Level of A5 to be 0 */
//  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_5, 0);
//
//  /*Configure GPIO pin : PA5 */
//  GPIO_InitStruct.Pin = GPIO_PIN_5;
//
//  //set the mode to be output and push pull
//  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
//
//  //set no pull down/up resistors
//  GPIO_InitStruct.Pull = GPIO_NOPULL;
//
//  //set the port speed to be low
//  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
//
//  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);


  /* in C directly */
  //GPIOA Port Clock Enable
  RCC_AHBENR |= 1 <<17;

  //configure GPIO pin Output Level to be 0
  PORTA_ODR |= (1<<5);

  //set the mode to be output
  //first clear bits in MODER
  PORTA_MODER &= ~(0b11 << 10);

  // then set 0b01 to MODER
  PORTA_MODER |= (0b01 << 10);

  //set the mode to be push pull
  PORTA_OTYPE &= ~(1<<5);

  //set no pull down/up resistors
  PORTA_PUPDR &= ~(0b11 << 10); //clear bits

  //set the port speed to be low
  PORTA_OSPEEDR &= ~(0b11 << 10);

}

void coast_delay(uint32_t val){
	for(uint32_t i=0; i<val; i++){
		for(uint32_t j=0;j<10000;j++){

		}
	}
}

void coast_loop_body(){

  //HAL_GPIO_TogglePin(GPIOA, GPIO_PIN_5);
  PORTA_ODR ^= 1<<5;

  //HAL_Delay(100)
  coast_delay(100);

}
