#!/usr/bin/env python

import rospy
from geometry_msgs.msg import Point

#----------------------------------------------------------------------
#
#----------------------------------------------------------------------


#----------------------------------------------------------------------
# Robot object
#----------------------------------------------------------------------

class Robot(object):
    def __init__(self, topic_name, queue_size):
        self._num_subscribers = 0
        self._pub = rospy.Publisher(topic_name, Point, queue_size=queue_size,
                                    subscriber_listener=self)

        # Initialise the location of the robot
        self._location = Point()
        self._location.x = 10
        self._location.y = 10
        self._location.z = 10

    #----------------------------------------------------------------
    # subscriber_listener not setup as a callback so the functions must be
    # named "peer_subscribe" and "peer_unsubscribe"
    # ----------------------------------------------------------------
    def peer_subscribe(self, topic_name, topic_publish, peer_publish):
        self._num_subscribers += 1
        if self._num_subscribers > 0:
            rospy.loginfo("Received subscriber connection: start publishing")
            self._timer = rospy.Timer(rospy.Duration(1), self.on_timer)

    def peer_unsubscribe(self, topic_name, num_peers):
        self._num_subscribers -= 1
        if self._num_subscribers == 0:
            self._timer.shutdown()
            rospy.loginfo("No more subscribers: stop publishing")
            self._timer = None

    #----------------------------------------------------------------
    # The timer callback
    #----------------------------------------------------------------
    def on_timer(self, event):
        rospy.loginfo("Publishing robot location: {0},{1}".format(
            self._location.x, self._location.y))
        self._pub.publish(self._location)

        # Simulate a move is some direction
        self._location.x += 1
        self._location.y += 2


#----------------------------------------------------------------------
# The startup function
#----------------------------------------------------------------------

def location_publish():
    rospy.init_node('robot_location_publisher')
    robot = Robot("robot_location", 10)


    rospy.spin()

#----------------------------------------------------------------------
#----------------------------------------------------------------------

if __name__ == '__main__':
    try:
        location_publish()
    except rospy.ROSInterruptException:
        pass

