#!/usr/bin/env python

import rospy
from geometry_msgs.msg import Point

#----------------------------------------------------------------------
# Robot object
#----------------------------------------------------------------------

class Robot(object):
    def __init__(self, pub):
        self._pub = pub

        # Initialise the location of the robot
        self._location = Point()
        self._location.x = 10
        self._location.y = 10
        self._location.z = 10

    def on_timer(self, event):
        rospy.loginfo("Publishing robot location: {0},{1}".format(
            self._location.x, self._location.y))
        self._pub.publish(self._location)

        # Simulate a move is some direction
        self._location.x += 1
        self._location.y += 2


#----------------------------------------------------------------------
# The startup function
#----------------------------------------------------------------------

def location_publish():
    rospy.init_node('robot_location_publisher')
    pub = rospy.Publisher('robot_location', Point, queue_size=10)
    robot = Robot(pub)

    rospy.Timer(rospy.Duration(1), robot.on_timer)

    rospy.spin()

#----------------------------------------------------------------------
#----------------------------------------------------------------------

if __name__ == '__main__':
    try:
        location_publish()
    except rospy.ROSInterruptException:
        pass

