#!/usr/bin/env python

import rospy
from geometry_msgs.msg import Point

def callback(location):
    rospy.loginfo("Received robot location: {0},{1}".format(location.x, location.y))

def location_listener():
    rospy.init_node('robot_location_listener')
    rospy.Subscriber('robot_location', Point, callback)

    # Handle the callback until the node is stopped
    rospy.spin()

if __name__ == '__main__':
    try:
        location_listener()
    except rospy.ROSInterruptException:
        pass

