/*
 * coast.c
 *
 *  Created on: Jun 15, 2025
 *      Author: hasin
 */

#include <stdint.h>

#define PORTA_MODER   (*((volatile uint32_t *)0x48000000))
#define PORTA_OTYPE   (*((volatile uint32_t *)0x48000004))
#define PORTA_OSPEEDR (*((volatile uint32_t *)0x48000008))
#define PORTA_PUPDR   (*((volatile uint32_t *)0x4800000C))
#define PORTA_IDR     (*((volatile uint32_t *)0x48000010))
#define PORTA_ODR     (*((volatile uint32_t *)0x48000014))

#define PORTC_MODER   (*((volatile uint32_t *)0x48000800))
#define PORTC_OTYPE   (*((volatile uint32_t *)0x48000804))
#define PORTC_OSPEEDR (*((volatile uint32_t *)0x48000808))
#define PORTC_PUPDR   (*((volatile uint32_t *)0x4800080C))
#define PORTC_IDR     (*((volatile uint32_t *)0x48000810))
#define PORTC_ODR     (*((volatile uint32_t *)0x48000814))

#define RCC_AHBENR    (*((volatile uint32_t *)0x40021014))

void coast_loop_body(){
//	if( HAL_GPIO_ReadPin(GPIOC, GPIO_PIN_13) == 0 ){
//		HAL_GPIO_WritePin(GPIOA, GPIO_PIN_5, 1);
//	}
	if((PORTC_IDR & 1<<13) == 0){
		PORTA_ODR |= 1<<5;
	}
}

void coast_gpio_init(){

//  /*in HAl*/
//  GPIO_InitTypeDef GPIO_InitStruct = {0};
//
//  /* GPIO Ports Clock Enable */
//  __HAL_RCC_GPIOC_CLK_ENABLE();
//  __HAL_RCC_GPIOA_CLK_ENABLE();
//
//  /*Configure GPIO pin Output Level */
//  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_5, GPIO_PIN_RESET);
//
//  /*Configure GPIO pin : PC13 */
//  GPIO_InitStruct.Pin = GPIO_PIN_13;
//  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
//  GPIO_InitStruct.Pull = GPIO_NOPULL;
//  HAL_GPIO_Init(GPIOC, &GPIO_InitStruct);
//
//  /*Configure GPIO pin : PA5 */
//  GPIO_InitStruct.Pin = GPIO_PIN_5;
//  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
//  GPIO_InitStruct.Pull = GPIO_NOPULL;
//  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
//  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*directly in C*/

  //enable clock for PORTA
  RCC_AHBENR |= (1<<17);

  //enable clock for PORTA
  RCC_AHBENR |= (1<<19);

  //configure GPIO pin Output Level of PA5 to be 0
  PORTA_ODR &= ~(1<<5);

  /*Configure GPIO pin : PC13 */

  //set PC13 as input
  PORTC_MODER &= ~(0b11 << 26);

  //set PC13 to have no pullup
  PORTC_PUPDR &= ~(0b11 << 26);

  /*Configure GPIO pin : PA5 */

  //set the mode to be output
  //first clear bits in MODER
  PORTA_MODER &= ~(0b11 << 10);
  // then set 0b01 to MODER
  PORTA_MODER |= (0b01 << 10);

  //set the mode to be push pull
  PORTA_OTYPE &= ~(1<<5);

  //set no pull down/up resistors
  PORTA_PUPDR &= ~(0b11 << 10); //clear bits

  //set the port speed to be low
  PORTA_OSPEEDR &= ~(0b11 << 10);

}
