% Revision problem: Week 7, Question 1
% 
% Run the M/M/1 simulation with length

%%%% 
% If you want to reproduce the results that I give in the tutorial
% solution, you will need to use the setting of the random number 
% generator that I have used. The setting is stored in the file 
% week07_q1_rand_setting in the variable rand_setting.  
% Comment out the following two lines if you want to use the setting I 
% used. 
load week07_q1_rand_setting
rng(rand_setting) 
% 
% I used the following two lines to obtain the setting of the random number
% generator and saved it to the file week07_q1_rand_setting so that I can
% reproduce the results later. I keep the code here to show you how you can
% save the setting.   
% rand_setting = rng;
% save week07_q1_rand_setting rand_setting

% Define the simulation parameters 
lambda = 0.7;
mu = 1;

% A vector of T (simulation end time)
T = [1000 5000 10000 50000];

% Matrix RT stores the results of the simulation
% RT is a 20-by-4 matrix
% Each column of RT stores the simulation results from using a particular
% value of T for simulation
% E.g. RT(i,j) contains the simulation by using the i-th value of T a the
% j-th replication
RT = zeros(20,4);

% iteration 
    for j = 1:4
        for i = 1:20
            RT(i,j) = sim_mm1_func(lambda,mu,T(j));
        end    
    end
  
% expected results from M/M/1 theory
rt_mm1 = 1/(mu-lambda);

% For a given arrival rate, increase the simulation length
semilogx(T,RT,'bo',T,rt_mm1*ones(length(T),1),'r-','Linewidth',3,'Markersize',12);
xlabel('Length of simulation T')
ylabel('Response time')
title('Horizontal line - theoretical value; circles - simulated values')
% print -depsc week07_q1_fig

% Mean over 20 replications for each value of T
mean(RT)

% standard deviation
std(RT)

% save week07_q1_data
