package au.edu.unsw.soacourse.orderservice.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import au.edu.unsw.soacourse.orderservice.model.Order;

public class OrderDaoImpl implements OrderDao {
	
	private Map<String, Order> orderStore = new HashMap<String, Order>();

    public OrderDaoImpl() {
    	
    	Order order1 = new Order();
		
		order1.setId("001");
		order1.setDrink("espresso");
		order1.setCost(4d);
		order1.setStatus("released"); //new->paid->preparing->released
				
		Order order2 = new Order();
		
		order2.setId("002");
		order2.setDrink("latte");
		order2.setCost(6d);
		order2.setStatus("preparing");
		
        orderStore.put("001", order1);
        orderStore.put("002", order2);
    }

	@Override
	public List<Order> findAllOrders() {
		
		List<Order> orders = new ArrayList<Order>();
		orders.addAll( orderStore.values() );
		return orders; 
	}

	@Override
	public Order findOrder(String orderId) {
		// TODO Auto-generated method stub
		return orderStore.get(orderId);
	}

	@Override
	public Order createOrder(String drink, String additions, Double cost) {
		// TODO Auto-generated method stub
		
		Order order1 = new Order();
		String newId = "00"+Integer.toString((orderStore.size() +1));
		order1.setId(newId);
		order1.setDrink(drink);
		order1.setCost(cost);
		order1.setAdditions(additions);
		order1.setStatus("new");
		
		orderStore.put(newId, order1);
		
		return order1;
	}

	@Override
	public Order updateOrder(Order ord) {
		// TODO Auto-generated method stub
		orderStore.put(ord.getId(), ord);
		return ord;
	}
	
	@Override
	public String deleteOrder(String orderId) {
		// TODO Auto-generated method stub
		if (orderStore.containsKey(orderId)) {
			orderStore.remove(orderId);
			return orderId;
		} else
			return null;
	}

}
