package au.edu.unsw.soacourse.orderservice.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import au.edu.unsw.soacourse.orderservice.model.Payment;

public class PaymentDaoImpl implements PaymentDao {
	
	private Map<String, Payment> paymentStore = new HashMap<String, Payment>();

    public PaymentDaoImpl() {
    	
    	Payment pay1 = new Payment();
		
		pay1.setOrder("001");
		pay1.setAmount(4d);
		pay1.setDetails("card1234");
				
	   	Payment pay2 = new Payment();
		
		pay2.setOrder("002");
		pay2.setAmount(6d);
		pay2.setDetails("cash1234");
		
        paymentStore.put("001", pay1);
        paymentStore.put("002", pay2);
    }
    
	public List<Payment> findAllPayments() {
		List<Payment> pays = new ArrayList<Payment>();
		pays.addAll( paymentStore.values() );
		return pays; 
	}
	
	public Payment findPaymentById(String order) {
		// TODO Auto-generated method stub
		return paymentStore.get(order);
	}

	public Payment createPayment(String order, Double amt, String details) {
		
		Payment p1 = new Payment();
		p1.setOrder(order);
		p1.setAmount(amt);
		p1.setDetails(details);
		
		paymentStore.put(order, p1);
		
		return p1;
	}

	public Payment updatePayment(Payment p) {
		paymentStore.put(p.getOrder(), p);
		return p;
	}

	public String deletePayment(String order) {
		if (paymentStore.containsKey(order)) {
			paymentStore.remove(order);
			return order;
		} else
			return null;
	}
}
