package au.edu.unsw.soacourse.orderservice;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import au.edu.unsw.soacourse.orderservice.dao.PaymentDao;
import au.edu.unsw.soacourse.orderservice.dao.PaymentDaoImpl;
import au.edu.unsw.soacourse.orderservice.model.Payment;


@Path("/payments")
public class PaymentServiceEI {

	private PaymentDao paymentDB = new PaymentDaoImpl();
	
	@GET
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public List<Payment> getAllPayments() {
		
		return paymentDB.findAllPayments();
	}
	
//  ===== To show PathParam =====	
	@GET
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	@Path("{orderId}") 
	public Response getPayment(@PathParam("orderId") String orderId) {
		Payment pay1 = paymentDB.findPaymentById(orderId);
		if (pay1 == null) {
			return Response.status(Response.Status.NOT_FOUND).build();
		} else {
			return Response.ok().entity(pay1).build();
		}
	}
	
//  ===== To show a couple of PUT =====
	@PUT
	@Path("{orderId}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public Response updatePayment(Payment p) {
				
		Payment updPay = paymentDB.updatePayment(p);
		return Response.ok().entity(updPay).build();
		
	}
	
//  ===== To show a couple of DELETE =====	
	@DELETE
	@Path("{orderId}")
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public Response delete (@PathParam ("orderId") String delOrdID) {

		String delOK = paymentDB.deletePayment(delOrdID);
		if (delOK == null) {
			return Response.status(Status.NOT_FOUND).build();
		} 	
		return Response.ok().build();
	}

}
