set NODES; #set of nodes
set EDGES := {i1 in NODES,i2 in NODES: i1 <> i2}; #set of edges
set FLOWS := {i1 in NODES,i2 in NODES: i1 <> i2}; #set of flows
set LINKTYPES;

param fb {(u,v) in FLOWS};  # size of flows
param sd {i in NODES, v in NODES} := if (i = v) then 1 else 0; 
# define origin destination pair
param cost {LINKTYPES};
param capacity {LINKTYPES};

var x {(u,v) in FLOWS,(i,j) in EDGES} binary;  # flow-edge choice
var y {(i,j) in EDGES, k in LINKTYPES} binary; 

minimize totalcost: sum {(i,j) in EDGES, k in LINKTYPES} y[i,j,k] * cost[k];

subject to flow_balance {i in NODES, (u,v) in FLOWS}: sum {(i,j) in EDGES} x[u,v,i,j] - sum{(j,i) in EDGES} x[u,v,j,i] = sd[i,u] - sd[i,v];

subject to capacity_constraint {(i,j) in EDGES}: sum {(u,v) in FLOWS} x[u,v,i,j] * fb[u,v] <= sum{k in LINKTYPES} capacity[k] * y[i,j,k]; 

subject to flow_logic {(i,j) in EDGES, (u,v) in FLOWS}: x[u,v,i,j] <= sum{k in LINKTYPES} y[i,j,k]; 

subject to type_choice {(i,j) in EDGES}: sum{k in LINKTYPES} y[i,j,k] <= 1;




