package au.edu.unsw.soacourse.orderservice;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;
import javax.ws.rs.core.Response.Status;

import au.edu.unsw.soacourse.orderservice.dao.OrderDao;
import au.edu.unsw.soacourse.orderservice.dao.OrderDaoImpl;
import au.edu.unsw.soacourse.orderservice.model.Order;

@Path("/orders")
public class OrderServiceEI {

	private OrderDao orderDB = new OrderDaoImpl();
	
	@GET
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public List<Order> getAllOrders() {
	
		return orderDB.findAllOrders();
	}

	
//  ===== To show QueryParam =====
	@GET
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public List<Order> getAllOrders(@QueryParam("top") int size) {
		System.out.println(size);
		
		return orderDB.findAllOrders();
	}

	
//  ===== To show PathParam =====	
	@GET
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	@Path("{orderId}") 
	public Order getOrder(@PathParam("orderId") String orderId) {
		
		return orderDB.findOrder(orderId);
	}
	
//  ===== To show a couple of POSTs =====
	@POST
	@Path("newOrder")
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public Response createOrderByParams(MultivaluedMap<String, String> formParams) {
		
		String drink = formParams.getFirst("drink");
		String additions = formParams.getFirst("additions");
		Double cost = Double.parseDouble(formParams.getFirst("cost"));
		Order newOrder = orderDB.createOrder(drink, additions, cost);
		
		ResponseBuilder builder = Response.ok(newOrder);
		builder.link("/SimpleStarBucks/orders/"+newOrder.getId(), "location");
		builder.link("/SimpleStarBucks/payments/"+newOrder.getId(), "payment");
		return builder.build();
	}

	@POST
	@Path("newOrder")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public Response createOrderByObj(Order order) {
		
		Order newOrder = orderDB.createOrder(order.getDrink(),order.getAdditions(), order.getCost());
		
		ResponseBuilder builder = Response.ok(newOrder);
		builder.link("/SimpleStarBucks/orders/"+newOrder.getId(), "location");
		builder.link("/SimpleStarBucks/payments/"+newOrder.getId(), "payment");
		return builder.build();
	}
	
//  ===== To show a couple of PUT =====
	@PUT
	@Path("{orderId}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public Response updateOrder(Order order) {
				
		// doing a non-workflow update
		Order updOrder = orderDB.updateOrder(order);
		return Response.ok().entity(updOrder).build();
	}
	
	
//  ===== To show a couple of DELETE =====	
	@DELETE
	@Path("{orderId}")
	@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
	public Response delete (@PathParam ("orderId") String delOrdID) {

		String delOK = orderDB.deleteOrder(delOrdID);
		if (delOK == null) {
			return Response.status(Status.NOT_FOUND).build();
		} 	
		return Response.ok().build();
	}

}
