#include <ros/ros.h>
#include <geometry_msgs/Point.h>

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

class Robot
{
public:
  Robot(ros::Publisher& pub);
  void timer_cb(const ros::TimerEvent& e);
private:
  geometry_msgs::Point location_;
  ros::Publisher pub_;
};

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
Robot::Robot(ros::Publisher& pub) : pub_(pub)
{
  location_.x = 10;
  location_.y = 10;
  location_.z = 10;
}

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
void Robot::timer_cb(const ros::TimerEvent& e)
{
  ROS_INFO_STREAM("Publishing robot location: " << location_.x << ", " << location_.y);
  pub_.publish(location_);

  // Simulate a move is some direction
  location_.x += 1;
  location_.y += 1;
}

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

int main(int argc, char **argv)
{
  ros::init(argc, argv, "robot_location_publisher");
  ros::NodeHandle nh;

  ros::Publisher pub = nh.advertise<geometry_msgs::Point>("robot_location", 10);
  Robot robot(pub);
  ros::Timer timer = nh.createTimer(ros::Duration(1.0), &Robot::timer_cb, &robot);

  ros::spin();
}


