#!/usr/bin/env python

import rospy
from geometry_msgs.msg import Point

def location_publish():
    rospy.init_node('robot_location_publisher')
    pub = rospy.Publisher('robot_location', Point, queue_size=10)
    rate = rospy.Rate(1) # 10hz

    # Initialise the location of the robot
    location = Point()
    location.x = 10
    location.y = 10
    location.z = 10

    while not rospy.is_shutdown():
        rospy.loginfo("Publishing robot location: {0},{1}".format(location.x, location.y))
        pub.publish(location)
        rate.sleep()

        # Simulate a move is some direction
        location.x += 1
        location.y += 2

if __name__ == '__main__':
    try:
        location_publish()
    except rospy.ROSInterruptException:
        pass

