/*
 * coast.c
 *
 *  Created on: Jul 7, 2024
 *      Author: hasin
 */
#include <stdint.h>

#define RCC_AHBENR      (*((volatile uint32_t *)0x40021014))

#define PORTA_MODER    (*((volatile uint32_t *)0x048000000))
#define PORTA_OTYPE     (*((volatile uint32_t *)0x048000004))
#define PORTA_OSPEEDR  (*((volatile uint32_t *)0x048000008))
#define PORTA_PUPDR     (*((volatile uint32_t *)0x04800000C))
#define PORTA_IDR        (*((volatile uint32_t *)0x048000010))
#define PORTA_ODR       (*((volatile uint32_t *)0x048000014))

void my_asm_delay(uint32_t count);

void my_delay(uint32_t count){
	for(uint32_t i=0; i<count; i++){
		for(uint32_t j=0;j <10000;j++){
		}
	}
}

void blink_mtd1(){
	PORTA_ODR |= 1<<5;
	my_asm_delay(100);

	//PORTA_ODR &= ~(1<<5);
	__asm__(
	"MOV r0, #0x048000000   \n"
	"LDR r1, [r0, #0x14]        \n"
	"BIC r1, r1, #1<<5           \n"
	"STR r1, [r0, #0x14]         \n"
	);

	my_delay(100);
}

void blink_mtd2(){
	//PORTA_ODR ^= 1<<5;
	__asm__(
	"MOV r0, #0x048000000   \n"
	"LDR r1, [r0, #0x14]        \n"
	"EOR r1, r1, #1<<5           \n"
	"STR r1, [r0, #0x14]         \n"
	);
	my_delay(100);
}

void my_switch(){
	if(PORTA_IDR & (1<<1)){
		PORTA_ODR |= 1<<5;
		while(PORTA_IDR & (1<<1));
		PORTA_ODR &= ~(1<<5);
	}
}

void my_loop_body(){

	blink_mtd1();
	//blink_mtd2();
	//my_switch();

}

void my_GPIO_Init(void)
{
  /* GPIOA Clock Enable */
  RCC_AHBENR |= (1<<17);

  /* PA5 as output */

  //reset just in case
  PORTA_ODR &= ~(1<<5);

  // set to output
  PORTA_MODER &= ~(0b11 << 10); // first clear bits in MODER
  PORTA_MODER |= (0b01 << 10); // then set 0b01 to MODER

  // push-pull
  PORTA_OTYPE &= ~(1<<5); //clear the bit
  //no pull up/down
  PORTA_PUPDR &= ~(0b11 << 10); //clear the two bits
  //output speed
  PORTA_OSPEEDR &= ~(0b11 << 10); //clear the two bits

  /* PA1 as input */

  //reset just in case
  PORTA_ODR &= ~(1<<1);
  // set to input
  PORTA_MODER &= ~(0b11 << 2); //clear the two bits
  //no pull up/down
  PORTA_PUPDR &= ~(0b11 << 2); //clear the two bits

}


